/******************************************************************************/
class CheckInt : BaseCheckVariable
{
public:
    CheckInt();
   ~CheckInt();
   
   virtual void create(Object &obj);
   virtual void AfterCreate(      );
   
   
private:

   void CallTriggeredAction();
   void StopTriggeredAction() {}
   
   UID m_IntUID;
   int m_TargetValue;
   ENUM_INT_CHECKS m_IntOperation;
   
   VarInt* m_VarInt;
};
/******************************************************************************/
CheckInt::CheckInt() : m_TargetValue(0), m_VarInt(null)                  
{

}
CheckInt::~CheckInt()
{
   
}
/******************************************************************************/
void CheckInt::create(Object &obj)
{
   // Getting the parameters from the object in the world
   
   if(Param *p = obj.findParam("False_EventGroupUID")) m_FalseUID     = p.asID();
   if(Param *p = obj.findParam("IntOperation"))        m_IntOperation = (ENUM_INT_CHECKS) p.asEnum();
   if(Param *p = obj.findParam("VarIntUID"))           m_IntUID       = p.asID();
   if(Param *p = obj.findParam("True_EventGroupUID"))  m_TrueUID      = p.asID();
   if(Param *p = obj.findParam("Value"))               m_TargetValue  = p.asInt();
   
   super.create(obj); // Create the BaseEvent params too
}
/******************************************************************************/
void CheckInt::AfterCreate()
{
   super.AfterCreate();
   
   // Find the correct VarInt to work on. This has to be done here, because it's unreliable during create() (not all objects are loaded yet)
   REPA(variablesInt)
      if(variablesInt[i].id() == m_IntUID)
         m_VarInt = &variablesInt[i];
         
   DEBUG_ASSERT(m_VarInt, "VarInt not found in scene");
}
/******************************************************************************/
void CheckInt::CallTriggeredAction()
{
   // Check the IntValue with the targetValue, using the correct bigger/smaller than operation
   int value = m_VarInt.GetValue();
   
   if(m_IntOperation == VALUE_LARGER_THAN)
   {
      if(value > m_TargetValue)
         TriggerTrueCondition();
         
      else TriggerFalseCondition();
   }
   else if(m_IntOperation == VALUE_LARGER_THAN_OR_EQUALS)
   {
      if(value >= m_TargetValue)
         TriggerTrueCondition();
         
      else TriggerFalseCondition();
   }
   else if(m_IntOperation == VALUE_SMALLER_THAN)
   {
      if(value < m_TargetValue)
         TriggerTrueCondition();
         
      else TriggerFalseCondition();           
   }
   else if(m_IntOperation == VALUE_SMALLER_THAN_OR_EQUALS)
   {
      if(value <= m_TargetValue)
         TriggerTrueCondition();
         
      else TriggerFalseCondition();           
   }
   else if(m_IntOperation == VALUE_EQUALS)
   {
      if(value == m_TargetValue)
         TriggerTrueCondition();
         
      else TriggerFalseCondition();              
   }
}
/******************************************************************************/